@extends('Website.layouts.app')
@section('extra-css')
    <link rel="stylesheet" href="{{app()->getLocale()=='en'?asset('website/css/custom/blog-details.css'):asset('website/css/custom/blog-details-rtl.css')}}">

@endsection
@section('page-title')
    {{__('website.followers')}}
@endsection

@section('banner')

    <section class="single-banner">
        <div class="container">
            <div class="row">
                <div class="col-lg-12">
                    <div class="single-content">
                        <h1> {{__('website.followers')}} </h1>
                        <ol class="breadcrumb">
                            <li class="breadcrumb-item"><a href="{{route('website.index')}}">{{__('website.home')}}</a></li>
                            <li class="breadcrumb-item"><a href="{{route('website.shop-details',['id'=>$shop->id,'slug'=>$shop->slug])}}">{{$shop->name}}</a></li>
                            <li class="breadcrumb-item active" aria-current="page">{{__('website.followers')}}</li>
                        </ol>
                    </div>
                </div>
            </div>
        </div>
    </section>
@endsection
@section('content')

<section class="blog-details-part">
    <div class="container">
        <div class="row">
            <div class="col-lg-10 m-auto">



                <div class="common-card no-padding" id="review">
                    <div class="card-header">
                        <h5 class="card-title">{{__('website.followers')}}
                            ({{count($shop->followers)}})</h5>
                    </div>
                    @if(count($followers))
                    <div class="ad-details-review">
                        <ul class="review-list">
                            @foreach($followers as $follower)
                            <li class="review-item follower-item">
                                <div class="review-user">
                                    <div class="review-head no-mb">
                                        <div class="review-profile"><a href="javascript:void(0)" class="review-avatar"><img src="{{$follower->image()??'/website/images/avatar/profile-default.png'}}" alt="{{$follower->name}}"></a>
                                            <div class="review-meta">
                                                <h6><a href="javascript:void(0)">{{$follower->name??__('website.visitor')}}</a></h6>
                                                <p> {{__('website.moon-user')}} </p>

                                            </div>
                                        </div>
                                    </div>

                                </div>
                            </li>
                            @endforeach
                        </ul>


                    </div>
                        @endif
                </div>
                <div class="row">
                    <div class="col-lg-12">
                        <div class="footer-pagection">
                            <p class="page-info">{{__('website.Showing')}} {{$followers->total()}} {{__('website.of')}}  {{$followers->perPage()}}{{__('website.results')}}</p>

                            {{$followers->links()}}

                        </div>

                    </div>
                </div>
            </div>
        </div>

    </div>

</section>
@endsection
