
@extends('Website.layouts.app')
@section('extra-css')
    <link rel="stylesheet" href="{{asset('website/css/custom/contact.css')}}">
    <link rel="stylesheet" href="{{asset('website/css/custom/style-upload.css')}}">
    <link rel="stylesheet" href="{{asset('website/css/custom/style-map.css')}}">

@endsection
@section('page-title')
    {{__('website.shops-on-map')}}
@endsection

@section('content')

<section class="map-part ">
    <div class="container-fluid">

        <div class="row">

            <div class="col-lg-12">

                <div id="map-canvas"></div>
            </div>
        </div>
    </div>
</section>
@endsection
@section('extra-js-files')

<script src="{{asset('website/js/custom/script-upload.js')}}"></script>
<script type="text/javascript" src="https://maps.google.com/maps/api/js?libraries=places&key=AIzaSyCnXtbPyAEiGsv0YBnR5eLE53ssWy4kiWk"></script>
<script>

    // set global variables
    var gmarkers1 = [];
    var markers1 = [];
    var infowindow = new google.maps.InfoWindow({
        content: ''
    });




    // Function to init map



    function initialize() {
        navigator.geolocation.getCurrentPosition(function(position) {
            let lat = position.coords.latitude;
            let lng = position.coords.longitude;


        var center = new google.maps.LatLng(lat, lng);
        var mapOptions = {
            zoom: 10,
            center: center,
            mapTypeID: google.maps.MapTypeId.ROADMAP
        };

        map = new google.maps.Map(document.getElementById('map-canvas'), mapOptions);
        for (i = 0; i < markers1.length; i++) {
            addMarker(markers1[i]);
        }
        });
    }


    // Function to add markers to map


    function addMarker(marker) {
        var category = marker[4];
        var title = marker[1];
        var pos = new google.maps.LatLng(marker[2], marker[3]);
        var content = marker[1];

        marker1 = new google.maps.Marker({
            title: title,
            position: pos,
            category: category,
            map: map
        });

        gmarkers1.push(marker1);

// Marker click listener (zoom in and open info window)
        google.maps.event.addListener(marker1, 'click', (function (marker1, content) {
            return function () {
                console.log('Gmarker 1 gets pushed');
                infowindow.setContent(content);
                infowindow.open(map, marker1);
                map.panTo(this.getPosition());
                map.setZoom(13);
            }
        })(marker1, content));
    }


    // Function to filter markers by category


    filterMarkers = function (category) {
        for (i = 0; i < markers1.length; i++) {
            console.log(markers1.length);
            marker = gmarkers1[i];
            // If is same category or category not picked
            if (marker.category == category || category.length === 0) {
                marker.setVisible(true);

            }

            // if Categories don't match
            else {
                marker.setVisible(false);
            }
        }
    }

    // Add markers (you can add as many as you like)
    // Note, marker #5 has a lot of styling and an image in the info window. Just showing an example of what you can do with an info window.
    markers1 = [
        @foreach($shops as $key=>$shop)
        ['{{$key+1}}',
        '<div style="font-size:12px; color:#000;">' +
        '<a href="{{route('website.shop-details',['id'=>$shop->id,'slug'=>$shop->slug])}}"><img id="popimg" src="{{$shop->image()}}"></a>' +
        '<br/>' +
        '<br/>' +
        '<strong>' +
        '{{__("website.address")}}:' +
        '</strong>' +
        '<br/>' +
        '{{$shop->address}}' +
        '<br/>' +
        '<br/>' +
        '<strong><strong>' +
        '{{__("website.phone")}}:</strong>' +
        '<br/>' +
        '{{$shop->phone}}<br/>' +
        '<br/>' +
        '<strong>' +
        '{{__("website.type")}}:</strong>' +
        '<br/>' +
        '({{$shop->name}})' +
        '<br/>' +
        '<br/>' +
        '</div>'
         , {{$shop->latitude}}, {{$shop->longitude}}, '{{$shop->name}}'],
        @endforeach
    ];

    // Init map
    initialize();




</script>
@endsection
