@extends('Website.layouts.app')
@section('extra-css')
    <link rel="stylesheet" href="{{asset('website/css/custom/vemdezap.css')}}">
    <link rel="stylesheet" href="{{asset('website/css/custom/facesnap.css')}}">
    <link rel="stylesheet" href="{{asset('website/css/custom/snapssenger.css')}}">
    <link rel="stylesheet" href="{{asset('website/css/custom/vemdezap.css')}}">
@endsection

@section('banner')
    <section class="single-banner">
        <div class="container">
            <div class="row">
                <div class="col-lg-12">
                    <div class="single-content">
                        <h1>{{__('website.stories')}}</h1>
                        <ol class="breadcrumb">
                            <li class="breadcrumb-item"><a href="{{route('website.index')}}">{{__('website.home')}}</a>
                            </li>
                            <li class="breadcrumb-item active" aria-current="page">{{__('website.stories')}}</li>
                        </ol>
                    </div>
                </div>
            </div>
        </div>
    </section>
@endsection
@section('page-title')
    {{__('website.stories')}}
@endsection

@section('content')
    <section class="section recomend-part story-part-inside">
        <div class="container">
            <div class="row">
                <div class="col-lg-12">
                    <div class="section-center-heading">
                        <h2> <span>{{__('website.moon')}}</span> {{__('website.shop-stories')}}</h2>
                        <p>
                            {{__('website.shop-stories-desc')}}
                        </p>
                    </div>
                </div>
            </div>
            <div class="row">
                <div class="col-lg-12">

                    <div id="stories" class="storiesWrapper stories story-preview list vemdezap "></div>


                </div>
            </div>
            {{--            <div class="row">--}}
            {{--                <div class="col-lg-12">--}}
            {{--                    <div class="footer-pagection no-border">--}}

            {{--                        <ul class="pagination center-pagination">--}}
            {{--                            <li class="page-item"><a class="page-link" href="#"><i class="fas fa-long-arrow-alt-left"></i></a></li>--}}
            {{--                            <li class="page-item"><a class="page-link active" href="#">1</a></li>--}}
            {{--                            <li class="page-item"><a class="page-link" href="#">2</a></li>--}}
            {{--                            <li class="page-item"><a class="page-link" href="#">3</a></li>--}}
            {{--                            <li class="page-item">...</li>--}}
            {{--                            <li class="page-item"><a class="page-link" href="#">67</a></li>--}}
            {{--                            <li class="page-item"><a class="page-link" href="#"><i class="fas fa-long-arrow-alt-right"></i></a></li>--}}
            {{--                        </ul>--}}
            {{--                    </div>--}}
            {{--                </div>--}}
            {{--            </div>--}}
            <div class="row">
                <div class="col-lg-12">
                    <div class="footer-pagection no-border">
                        {{$stories->links()}}
                    </div>
                </div>
            </div>

        </div>
        </div>


        </div>
    </section>

@endsection
@section('extra-js-files')
    <script src="{{asset('website/js/custom/zuck.min.js')}}"></script>
    <script src="{{asset('website/js/custom/script-story.js')}}"></script>
    <script>
        var currentSkin = getCurrentSkin();
        var stories = new Zuck('stories', {
            backNative: true,
            previousTap: true,
            skin: currentSkin['name'],
            autoFullScreen: currentSkin['params']['autoFullScreen'],
            avatars: currentSkin['params']['avatars'],
            paginationArrows: currentSkin['params']['paginationArrows'],
            list: currentSkin['params']['list'],
            cubeEffect: currentSkin['params']['cubeEffect'],
            localStorage: false,
            stories: [
                @if(count($stories)>0)
                @foreach($stories as $store)
                Zuck.buildTimelineItem(
                    "{{$store->image()}}",
                    "{{$store->image()}}",

                    "{{$store->name}}",
                    "{{$store->image()}}",

                    timestamp(),
                    [
                            @foreach($store->stories as $story)
                        ["{{$store->name}}", "photo", 3, "{{$story->file()}}", " {{$story->file()}}", 'Write A Comment', false, false, timestamp()],
                        @endforeach
                    ]
                ),
                @endforeach
                @endif
                // Zuck.buildTimelineItem(
                //     "gorillaz",
                //     "images/story/client-2.jpg",
                //     "Burger King 2",
                //     "",
                //     timestamp(),
                //     [
                //         ["gorillaz-1", "video", 0, "images/video.mp4", "images/1.jpg", 'message.html', ' Write a comment ' , false, false, timestamp()],
                //         ["gorillaz-2", "photo", 3, "images/1.jpg", "images/1.jpg",  'message.html', ' Write a comment ', false, false, timestamp()],
                //         ["gorillaz-2", "photo", 3, "images/1.jpg", "images/1.jpg",  'message.html', ' Share2 ', ' like ', false, false, timestamp()],
                //
                //     ]
                // ),
                // Zuck.buildTimelineItem(
                //     "ladygaga",
                //     "images/story/client-3.jpg",
                //     "Bufflo",
                //     "",
                //     timestamp(),
                //     [
                //         ["ladygaga-1", "photo", 5, "images/1.jpg", "images/1.jpg", '', false, false, timestamp()],
                //         ["ladygaga-2", "photo", 3, "images/1.jpg", "images/1.jpg", 'http://ladygaga.com', false, false, timestamp()],
                //     ]
                // ),
                // Zuck.buildTimelineItem(
                //     "starboy",
                //     "images/story/client-3.jpg",
                //     "KFC",
                //     "",
                //     timestamp(),
                //     [
                //         ["starboy-1", "photo", 5, "images/1.jpg", "images/1.jpg", '', false, false, timestamp()]
                //     ]
                // ),
                // Zuck.buildTimelineItem(
                //     "riversquomo",
                //     "images/story/client-4.jpg",
                //     "Hadrmot",
                //     "",
                //     timestamp(),
                //     [
                //         ["riverscuomo", "photo", 10, "images/1.jpg", "images/1.jpg", '', false, false, timestamp()]
                //     ]
                // ),
                // Zuck.buildTimelineItem(
                //     "test2",
                //     "images/story/client-5.jpg",
                //     "shawermty",
                //     "",
                //     timestamp(),
                //     [
                //         ["riverscuomo", "photo", 11, "images/1.jpg", "images/1.jpg", '', false, false, timestamp()]
                //     ]
                // ),
                // Zuck.buildTimelineItem(
                //     "test",
                //     "images/story/client-6.jpg",
                //     "king BG",
                //     "",
                //     timestamp(),
                //     [
                //         ["riverscuomo", "photo", 12, "images/1.jpg", "images/1.jpg", '', false, false, timestamp()]
                //     ]
                // ),
                // Zuck.buildTimelineItem(
                //     "test3",
                //     "images/story/client-7.jpg",
                //     "Shrimp Zone",
                //     "",
                //     timestamp(),
                //     [
                //         ["riverscuomo", "photo", 13, "images/1.jpg", "images/1.jpg", '', false, false, timestamp()]
                //     ]
                // )
                // ,
                // Zuck.buildTimelineItem(
                //     "test4",
                //     "images/story/client-8.jpg",
                //     "Premos Pizza",
                //     "",
                //     timestamp(),
                //     [
                //         ["riverscuomo", "photo", 14, "images/1.jpg", "images/1.jpg", '', false, false, timestamp()]
                //     ]
                // )
                // ,
                // Zuck.buildTimelineItem(
                //     "test5",
                //     "images/story/client-9.jpg",
                //     "El Monofy",
                //     "",
                //     timestamp(),
                //     [
                //         ["riverscuomo", "photo", 15, "images/1.jpg", "images/1.jpg", '', false, false, timestamp()]
                //     ]
                // )
                // ,
                // Zuck.buildTimelineItem(
                //     "test6",
                //     "images/story/client-10.jpg",
                //     "Falah Foods",
                //     "",
                //     timestamp(),
                //     [
                //         ["riverscuomo", "photo", 16, "images/1.jpg", "images/1.jpg", '', false, false, timestamp()]
                //     ]
                // )
                // ,
                // Zuck.buildTimelineItem(
                //     "test7",
                //     "images/story/client-11.jpg",
                //     "Big Tasty",
                //     "",
                //     timestamp(),
                //     [
                //         ["riverscuomo", "photo", 17, "images/1.jpg", "images/1.jpg", '', false, false, timestamp()]
                //     ]
                // )
                // ,
                // Zuck.buildTimelineItem(
                //     "test8",
                //     "images/story/client-6.jpg",
                //     "Shrimp",
                //     "",
                //     timestamp(),
                //     [
                //         ["riverscuomo", "photo", 18, "images/1.jpg", "images/1.jpg", '', false, false, timestamp()]
                //     ]
                // )
                //
            ]
        });
    </script>

@endsection
