<?php

use Illuminate\Support\Facades\Route;
use App\Http\Controllers\Website\GetHomeController;
use App\Http\Controllers\Website\GetCategoriesController;
use App\Http\Controllers\Website\GetStoriesController;
use App\Http\Controllers\Website\ShopsController;
use App\Http\Controllers\Website\GetAdvertisementsController;
use App\Http\Controllers\Website\GetCitiesController;
use App\Http\Controllers\Website\GetAdvertisementDetailsController;
use App\Http\Controllers\Website\BlogsController;
use App\Http\Controllers\Website\ExploresController;
use App\Http\Controllers\Website\GetPackagesController;
use App\Http\Controllers\Website\GetSettingsController;
use App\Http\Controllers\Website\AuthController;
use App\Http\Controllers\Website\ActionsController;
use App\Http\Controllers\Website\GetNotificationsController;

Route::get('/', function () {
    return redirect(app()->getLocale());
});
//Route::middleware('locale')->group(function ($locale) {
Route::group([
    'prefix' => '{locale}',
    'where' => ['locale' => '[a-zA-Z]{2}'],
    'middleware' => 'locale'], function ()
   { //   \Illuminate\Support\Facades\App::setLocale($locale);
       Route::fallback(function () {
           return view("Website.pages.errors.404"); // template should exists
       });

       Route::get('categories', GetCategoriesController::class)->name('website.all-categories');
    Route::get('stories', GetStoriesController::class)->name('website.all-stories');

    Route::any('shop/{city}', [ShopsController::class, 'index'])->name('website.all-shops');
    Route::get('shop/{id}/{slug}', [ShopsController::class, 'show'])->name('website.shop-details');
    Route::get('followers/{id}', [ShopsController::class, 'followers'])->name('website.followers');
    Route::get('viewers/{id}', [ShopsController::class, 'viewers'])->name('website.viewers');
    Route::get('reviews/{id}', [ShopsController::class, 'reviews'])->name('website.reviews');
    Route::get('cities', GetCitiesController::class)->name('website.all-cities');
    Route::get('explores', [ExploresController::class, 'index'])->name('website.view-all-explores');
    Route::get('explore/{id}', [ExploresController::class, 'show'])->name('website.explore-details');

    Route::get('blogs', [BlogsController::class, 'index'])->name('website.view-all-blogs');
    Route::get('blogs/{id}/{slug}', [BlogsController::class, 'show'])->name('website.blog-details');
    Route::get('map', [ShopsController::class, 'shopsOnMap'])->name('website.shops-on-map');
    Route::get('packages', GetPackagesController::class)->name('website.packages');
    Route::get('contact-us', [GetSettingsController::class, 'contactUs'])->name('website.contact-us');
    Route::post('contact-us', [GetSettingsController::class, 'submitContactForm'])->name('website.contact-us-submit');
    Route::get('about', [GetSettingsController::class, 'about'])->name('website.about');
    Route::get('terms', [GetSettingsController::class, 'terms'])->name('website.terms');
    Route::get('safety-steps', [GetSettingsController::class, 'safetySteps'])->name('website.safety-steps');
    Route::get('payment-method', [GetSettingsController::class, 'paymentMethods'])->name('website.payment-method');
    Route::get('get-sub-categories', [GetSettingsController::class, 'subCategories'])->name('website.get-sub-categories');
    Route::get('categories', GetCategoriesController::class)->name('website.all-categories');


    Route::group(['middleware' => 'auth'], function () {
        Route::group(['prefix' => 'user'], function () {


            Route::get('shops/following', [ShopsController::class, 'followedShops'])->name('website.view-all-followed-shops');
            Route::get('follow', [ActionsController::class, 'follow'])->name('website.follow');
            Route::post('report-block', [ActionsController::class, 'reportBlock'])->name('website.report-block');
            Route::get('unblock', [ActionsController::class, 'unBlock'])->name('website.shop-unblock');
            Route::post('report-advertisement', [ActionsController::class, 'reportAdvertisement'])->name('website.report-advertisement');
            Route::post('add-blog-comment/{blog_id}', [BlogsController::class, 'addComment'])->name('website.add-blog-comment');
            Route::get('favorites', [AuthController::class, 'favorites'])->name('website.favorites');
            Route::get('favorite', [ActionsController::class, 'favorite'])->name('website.favorite');
            Route::get('favorite-explore', [ActionsController::class, 'favoriteExplore'])->name('website.favorite.explore');
            Route::post('comment-explore/{explore_id}', [ActionsController::class, 'storeExploreComment'])->name('website.comment.explore');
            Route::get('logout', [AuthController::class, 'logout'])->name('website.logout');
            Route::get('profile/{id}', [AuthController::class, 'profile'])->name('website.profile');
            Route::post('profile', [AuthController::class, 'updateProfile'])->name('website.update-profile');
            Route::get('last-seen-ads', [AuthController::class, 'lastSeenAds'])->name('website.last-seen-ads');
            Route::get('followed-shops', [AuthController::class, 'followedShops'])->name('website.followed-shops');
            Route::get('blocked-shops', [AuthController::class, 'blockedShops'])->name('website.blocked-shops');
            Route::get('last-search', [AuthController::class, 'lastSearch'])->name('website.last-search');
            Route::get('notifications', GetNotificationsController::class)->name('website.notifications');
            Route::post('add-comment', [ActionsController::class, 'addComment'])->name('website.add-comment');

        });
    });
    Route::get('/login', [AuthController::class, 'login'])->name('website.login');
   Route::get('login/{provider}', [AuthController::class, 'redirectToProvider'])->name('socialLogin.redirect');
   Route::get('login/{provider}/callback', [AuthController::class, 'handleProviderCallback'])->name('socialLogin.callback');

       Route::get('/change-country', [ActionsController::class, 'changeCountry'])->name('website.change-country');
    Route::get('/change-currency', [ActionsController::class, 'changeCurrency'])->name('website.change-currency');
    Route::get('/change-language', [ActionsController::class, 'changeLanguage'])->name('website.change-language');
    Route::post('/login', [AuthController::class, 'submitLogin'])->name('website.submit.login');
    Route::get('/code/{phone}', [AuthController::class, 'code'])->name('website.verify');
    Route::post('/code', [AuthController::class, 'verifyCode'])->name('website.submit.verify');
    Route::get('faq/questions/{type}', [GetSettingsController::class, 'help'])->name('website.help');

    Route::any('/{category}', GetAdvertisementsController::class)->name('website.all-advertisements');

    Route::get('{id}/{slug}', GetAdvertisementDetailsController::class)->name('website.advertisement-details');

    Route::get('/', GetHomeController::class)->name('website.index');

});

//});
