<footer class="footer-part">
    <div class="container">
        <div class="row newsletter">
            <div class="col-lg-6">
                <div class="news-content">
                    <h2><?php echo e(__('website.Subscribe for Latest Offers')); ?></h2>
                    <p><?php echo e(__('website.Buy and sell everything from used cars to mobile phones and computers, or search for property, jobs and more in the world with moon')); ?>

                        .

                    </p>
                </div>
            </div>
            <div class="col-lg-6">
                <form class="news-form" action="<?php echo e(route('website.contact-us-submit')); ?>" method="post">
                    <?php echo csrf_field(); ?>
                    <input type="hidden" name="type" value="1">
                    <input type="email" name="email" placeholder="<?php echo e(__('website.enter-your-email-address')); ?>">
                    <button class="btn btn-inline" type="submit">
                        <i class="fas fa-envelope"></i>
                        <span><?php echo e(__('website.subscribe')); ?></span>
                    </button>
                    <?php if(Session::has('success-contact')): ?>

                        <div class="alert alert-success alert-dismissible">
                            <a href="#" class="close" data-dismiss="alert" aria-label="close">&times;</a>
                            <strong><?php echo e(__('website.email')); ?>!</strong> <?php echo e(Session::get('success')); ?>.
                        </div>
                    <?php endif; ?>

                </form>
            </div>
        </div>
        <div class="row">
            <div class="col-sm-6 col-md-6 col-lg-3">
                <div class="footer-content">
                    <h3><?php echo e(__('website.contact-us')); ?></h3>
                    <ul class="footer-address">
                        <li><i class="fas fa-map-marker-alt"></i>
                            <p> <?php echo e($settings[\App\Helpers\Constant::SETTING_KEYS['Address']]->content); ?></p>

                        </li>
                        <li><i class="fas fa-envelope"></i>
                            <a class="phone"
                               href="mailto:Info@moon4online.com">  <?php echo e($settings[App\Helpers\Constant::SETTING_KEYS['Email']]->content); ?> </a>
                        </li>
                        <li><i class="fas fa-phone-alt"></i>
                            <a class="phone"
                               href="tel:$phone1->title"><?php echo e($settings[\App\Helpers\Constant::SETTING_KEYS['Phone']]->content); ?></a>


                        </li>
                    </ul>
                </div>
            </div>
            <div class="col-sm-6 col-md-6 col-lg-3">
                <div class="footer-content">
                    <h3><?php echo e(__('website.quick-links')); ?></h3>
                    <ul class="footer-widget">
                        <li><a href="<?php echo e(route('website.about')); ?>"><?php echo e(__('website.about-moon')); ?></a></li>
                            <li>
                                <a href="<?php echo e(route('store.register')); ?>"><?php echo e(__('website.be-a-shop')); ?></a>
                            </li>
                            <li>
                                <a href="<?php echo e(route('website.packages')); ?>"><?php echo e(__('website.moon-pricing')); ?></a>
                            </li>
                            <li>
                                <a href="<?php echo e(route('website.login')); ?>"><?php echo e(__('website.login')); ?></a>
                            </li>
                            <li>
                                <a href="<?php echo e(route('website.all-shops','all')); ?>"><?php echo e(__('website.shops')); ?></a>
                            </li>
                    </ul>
                </div>
            </div>
            <div class="col-sm-6 col-md-6 col-lg-3">
                <div class="footer-content">
                    <h3><?php echo e(__('website.information')); ?></h3>
                    <ul class="footer-widget">
                        <li><a href="<?php echo e(route('website.contact-us')); ?>"><?php echo e(__('website.contact-us')); ?></a></li>
                        <li><a href="<?php echo e(route('website.help','how-to-use')); ?>"><?php echo e(__('website.how-to-use-site')); ?></a></li>
                        <li><a href="<?php echo e(route('website.payment-method')); ?>"><?php echo e(__('website.payment-method')); ?></a></li>
                        <li><a href="<?php echo e(route('website.safety-steps')); ?>"><?php echo e(__('website.safety-steps')); ?></a></li>
                        <li><a href="<?php echo e(route('website.help','help')); ?>"><?php echo e(__('website.help')); ?></a></li>
                    </ul>
                </div>
            </div>
            <div class="col-sm-6 col-md-6 col-lg-3">
                <div class="footer-info">
                    <a href="<?php echo e(route('website.index')); ?>">
                        <img src="<?php echo e(asset('website/images/logo.png')); ?>" alt="moon" width="159px" height="40px" ></a>
                    <ul class="footer-count">
                        <li>
                            <h5><?php echo e($usersCount); ?></h5>
                            <p><?php echo e(__('website.registered-users')); ?></p>
                        </li>
                        <li>
                            <h5><?php echo e($advertisementsCount); ?></h5>
                            <p><?php echo e(__('website.number-of-advertisements')); ?></p>
                        </li>
                        <li>
                            <h5><?php echo e($viewsCount); ?></h5>
                            <p><?php echo e(__('website.number-of-views')); ?></p>
                        </li>

                    </ul>
                </div>
            </div>
        </div>
        <div class="row">
            <div class="col-lg-12">
                <div class="footer-card-content">
                    <div class="footer-payment">
                        <a href="<?php echo e(route('website.payment-method')); ?>"><img src="<?php echo e(asset('website/images/pay-card/01.png')); ?>"
                                         alt="moon" width="58px" height="38px"></a><a
                            href="<?php echo e(route('website.payment-method')); ?>"><img src="<?php echo e(asset('website/images/pay-card/02.png')); ?>" alt="moon" width="58px" height="38px"></a><a
                            href="<?php echo e(route('website.payment-method')); ?>"><img
                                src="<?php echo e(asset('website/images/pay-card/03.png')); ?>" alt="moon" width="58px" height="38px"></a><a href="<?php echo e(route('website.payment-method')); ?>"><img
                                src="<?php echo e(asset('website/images/pay-card/04.png')); ?>" alt="moon" width="58px" height="38px"></a></div>
                    <div class="footer-option">
                        <?php if(count($allCountries)>0): ?>

                            <button type="button"  style="padding: 5px 10px; width: auto;">
                                <?php if(Session::has('currency')): ?><?php echo e(Session::get('currency')); ?> <?php else: ?> <?php echo e($selectedCountry->currency); ?> <?php endif; ?>
                            </button>

                            <button type="button" data-toggle="modal" data-target="#country" style="padding: 5px 10px; width: auto;"><i
                                    class="fas fa-flag"></i><?php if(Session::has('country_name')): ?><?php echo e(Session::get('country_name')); ?> <?php else: ?> <?php echo e($selectedCountry->name); ?> <?php endif; ?>
                            </button>
                        <?php endif; ?>
                            <button class="lang" type="button" data-toggle="modal"
                                    data-target="#language"><i class="fas fa-globe"></i><?php echo e(app()->getLocale()=='en'?__('website.english'):__('website.arabic')); ?></button>

                    </div>
                    <div class="footer-app"><a href="https://play.google.com/store/apps/details?id=grand.app.moon"><img src="<?php echo e(asset('website/images/play-store.png')); ?>"
                                                             alt="play-store"
                                                             class="download-store" width="128px" height="38px"></a><a href="https://apps.apple.com/om/app/moon-user/id1548901867"><img
                                src="<?php echo e(asset('website/images/app-store.png')); ?>"
                                alt="app-store" class="download-store" width="128px" height="38px"></a>
                        <a href="https://apkapp.gallery/dl/104477639/Moon">
                            <img src="<?php echo e(asset('website/images/hawawi.png')); ?>" alt="hawawi" class="download-store" width="128px" height="38px"></a>
                    </div>
                </div>
            </div>
        </div>
    </div>
    <div class="footer-end">
        <div class="container">
            <div class="footer-end-content">
                <p><?php echo e(__('website.copy-right')); ?> &copy; 2022 <a
                        href="<?php echo e(route('website.index')); ?>"><?php echo e(__('website.moon')); ?></a></p>
                <?php if(count($socialMedia)>0): ?>
                    <ul class="footer-social">
                        <?php $__currentLoopData = $socialMedia; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $social): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <li><a href="<?php echo e($social->content); ?>"><i class="fab fa-<?php echo e(strtolower($social->getTranslation('en')->title)); ?>"></i></a></li>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </ul>
                <?php endif; ?>
            </div>
        </div>
    </div>
</footer>
<div class="modal fade" id="currency">
    <div class="modal-dialog modal-dialog-centered">
        <div class="modal-content">
            <div class="modal-header">
                <h4><?php echo e(__('website.Choose a Currency')); ?></h4>
                <button class="fas fa-times" data-dismiss="modal"></button>
            </div>
            <div class="modal-body">
                <?php $__currentLoopData = $allCountries->pluck('currency')->toArray(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $currency): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <button onclick="changeCurrency('<?php echo e($currency); ?>')"
                            class="modal-link
                            <?php if(Session::has('currency') && Session::get('currency')==$currency): ?>
                                active
                            <?php elseif(!Session::has('currency') && $selectedCountry->currency==$currency): ?>
                                active
                            <?php else: ?>

                            <?php endif; ?>">

                        <?php echo e($currency); ?>


                    </button>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
            </div>
        </div>
    </div>
</div>
<div class="modal fade" id="country">
    <div class="modal-dialog modal-dialog-centered">
        <div class="modal-content">
            <div class="modal-header">
                <h4><?php echo e(__('website.choose-a-country')); ?></h4>
                <button class="fas fa-times" data-dismiss="modal"></button>
            </div>
            <div class="modal-body lang-body">
                <?php if(count($allCountries)>0): ?>
                    <?php $__currentLoopData = $allCountries; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $country): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <button onclick="changeCountry(<?php echo e($country->id); ?>,'<?php echo e($country->name); ?>')"
                                class="modal-link
                              <?php if(Session::has('country') && Session::get('country')==$country->id): ?>
                                    active
                                <?php elseif(!Session::has('country') && $selectedCountry->name==$country->name): ?>
                                    active
                                  <?php else: ?>
                                    jdjdj

                                <?php endif; ?>
                                    "><?php echo e($country->name); ?></button>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                <?php endif; ?>

            </div>
        </div>
    </div>
</div>
<div class="modal fade" id="language">
    <div class="modal-dialog modal-dialog-centered">
        <div class="modal-content">
            <div class="modal-header">
                <h4><?php echo e(__('website.choose-a-language')); ?></h4>
                <button class="fas fa-times" data-dismiss="modal"></button>
            </div>
            <div class="modal-body lang-body">
                        <button onclick="window.location='<?php echo e(route('website.change-language',['language'=>'en'])); ?>'"
                                class="modal-link <?php if(app()->getLocale()=='en'): ?>  active <?php endif; ?>"><?php echo e(__('website.english')); ?></button>
                        <button onclick="window.location='<?php echo e(route('website.change-language',['language'=>'ar'])); ?>'"
                                class="modal-link  <?php if(app()->getLocale()=='ar'): ?>  active <?php endif; ?>"><?php echo e(__('website.arabic')); ?></button>

            </div>
        </div>
    </div>
</div>
<?php echo $__env->yieldContent('extra-models'); ?>
<?php /**PATH /home/mtest/public_html/_wildcard_/resources/views/Website/layouts/includes/footer.blade.php ENDPATH**/ ?>