<header class="header-part">
    <div class="container">
        <div class="header-content">
            <div class="header-left">
                <button type="button" class="header-widget sidebar-btn"><i
                            class="fas fa-align-left"></i></button>
                <a href="<?php echo e(route('website.index')); ?>" class="header-logo"><img
                            src="<?php echo e(asset('website/images/logo.png')); ?>" alt="moon" width="159px" height="40px"></a>


                <div class="footer-option no-margin shops-button">
                    <button class="lang" type="button" onclick="location.href='<?php echo e(route('store.register')); ?>'"><i class="fas fa-store"></i><?php echo e(__('website.be-a-shop')); ?></button>
                </div>
            </div>
            <form class="header-form" action="<?php echo e(route('website.all-advertisements','all')); ?>?Type='Search'" method="get">

                <div class="header-search">
                    <button type="submit" title="Search Submit "><i
                                class="fas fa-search"></i></button>
                    <input type="text"
                           placeholder="<?php echo e(__('website.search-text')); ?>" value="<?php echo e(request()->text??old('text')); ?>" name="text">
                    <button type="button" title="Search Option"
                            class="option-btn"><i class="fas fa-sliders-h"></i></button>
                </div>
                <div class="header-option">
                    <div class="option-grid">
                        <div class="option-group">
                            <select name="city_id[]">
                                <option label="<?php echo e(__('website.select-city')); ?>"></option>
                                <?php if(count($cities)): ?>
                                    <?php $__currentLoopData = $cities; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $city): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <option value="<?php echo e($city->id); ?>"><?php echo e($city->name); ?></option>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                <?php endif; ?>
                            </select>
                        </div>
                        <div class="option-group">
                            <select name="category_id[]" onchange="selectSubCategory(this.options[this.selectedIndex].value)">

                                <option label="<?php echo e(__('website.select-category')); ?>"></option>

                                <?php if(count($categories)): ?>
                                    <?php $__currentLoopData = $categories; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $category): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <option value="<?php echo e($category->id); ?>"><?php echo e($category->name); ?></option>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                <?php endif; ?>
                            </select>
                        </div>
                        <div class="option-group" id="select-sub-div">
                            <select name="sub_category_id[]" id="select-sub-category" disabled >

                                <option label="<?php echo e(__('website.select-sub-category')); ?>"></option>

                            </select>
                        </div>
                        <div class="option-group">
                            <select name="sortBy">
                                <option label="<?php echo e(__('website.sort-by')); ?>"></option>
                                <option value="rated" ><?php echo e(__('website.most-rated')); ?></option>
                                <option value="price"><?php echo e(__('website.price')); ?></option>
                                <option value="date"><?php echo e(__('website.date')); ?></option>
                            </select>
                        </div>
                        <div class="option-group"><input type="text" min="<?php echo e($minPrice); ?>" name="min_price"
                                                         placeholder="<?php echo e(__('website.min-price',['Min-price'=>$minPrice])); ?>">
                        </div>
                        <div class="option-group"><input type="text" max="<?php echo e($maxPrice); ?>" name="max_price"
                                                         placeholder="<?php echo e(__('website.max-price',['Max-price'=>$maxPrice])); ?>">
                        </div>
                        <button
                                type="submit"><i class="fas fa-search"></i><span><?php echo e(__('website.search')); ?></span>
                        </button>
                    </div>
                </div>

            </form>
            <div class="header-right">
                <?php if(auth()->user()): ?>
                    <ul class="header-list">
                        <li class="header-item"><a href="<?php echo e(route('website.favorites')); ?>" class="header-widget"><i
                                        class="fas fa-heart"></i><sup id="favorite-count"><?php echo e(auth()->user()?count($favorites):$favorites); ?></sup></a></li>
                        <li class="header-item">
                            <button type="button" class="header-widget">
                                <i class="fas fa-bell"></i><sup>0</sup>
                            </button>
                            <div class="dropdown-card">
                                <div class="dropdown-header">
                                    <h5>Notification (1)</h5>
                                    <a href="<?php echo e(route('website.notifications')); ?>"><?php echo e(__('website.view-all')); ?></a>
                                </div>
                                <ul class="notify-list">
                                    <?php if(count($notifications)): ?>
                                        <?php $__currentLoopData = $notifications->take(5); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $notification): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                            <li class="notify-item <?php if($notification->seen==0): ?>active <?php endif; ?>">
                                                <?php if($notification->type==\App\Helpers\Constant::NOTIFICATION_TYPE['Store']): ?>
                                                    <a href="<?php echo e(route('website.shop-details',['id'=>$notification->action_by_id,'slug'=>$notification->store->slug])); ?>"
                                                       class="notify-link">
                                                        <div class="notify-img"><img
                                                                    src="<?php echo e($notification->store->image()?$notification->store->image():'website/images/favicon.png'); ?>"
                                                                    alt="avatar"></div>
                                                        <div class="notify-content">
                                                            <p class="notify-text">
                                                                <span><?php echo e($notification->store->name); ?></span><br>
                                                                <?php echo e($notification->text); ?></span></p>
                                                            <span class="notify-time"><?php echo e($notification->created_at); ?></span>
                                                        </div>
                                                    </a>
                                                <?php elseif($notification->type==\App\Helpers\Constant::NOTIFICATION_TYPE['Advertisement']): ?>
                                                    <a href="<?php echo e(route('website.advertisement-details',['id'=>$notification->action_by_id,'slug'=>$notification->advertisement->slug])); ?>"
                                                       class="notify-link">
                                                        <div class="notify-img"><img
                                                                    src="<?php echo e($notification->advertisement->image()?$notification->advertisement->image():'website/images/favicon.png'); ?>"
                                                                    alt="avatar"></div>
                                                        <div class="notify-content">
                                                            <p class="notify-text">
                                                                <span><?php echo e($notification->advertisement->title); ?></span><br>
                                                                <?php echo e($notification->text); ?>

                                                            </p>
                                                            <span class="notify-time"><?php echo e($notification->created_at); ?></span>
                                                        </div>
                                                    </a>

                                                <?php else: ?>
                                                    <a href="javascript:void(0)" class="notify-link">
                                                        <div class="notify-img"><img
                                                                    src="<?php echo e(\App\Models\Setting::where('key',\App\Helpers\Constant::SETTING_KEYS['Logo'])->first()?getImage(\App\Models\Setting::where('key',\App\Helpers\Constant::SETTING_KEYS['Logo'])->first()->image):'website/images/favicon.png'); ?>"
                                                                    alt="avatar"></div>
                                                        <div class="notify-content">
                                                            <p class="notify-text">
                                                                <span><?php echo e(__('website.admin')); ?></span><br>
                                                                <?php echo e($notification->text); ?>

                                                            </p>
                                                            <span class="notify-time"><?php echo e($notification->created_at); ?></span>
                                                        </div>
                                                    </a>


                                                <?php endif; ?>
                                            </li>
                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                    <?php endif; ?>
                                </ul>
                            </div>
                        </li>
                    </ul>
                <?php else: ?>
                    <ul class="header-list">
                        <li class="header-item">
                            <a href="<?php echo e(route('website.login')); ?>" class="header-widget">
                                <i class="fas fa-heart"></i><sup>0</sup></a></li>
                        <li class="header-item">
                            <a href="<?php echo e(route('website.login')); ?>" class="header-widget">
                                <i class="fas fa-bell"></i><sup>0</sup></a>
                        </li>
                    </ul>

                <?php endif; ?>
                <?php if(!auth()->user()): ?>

                    <a href="<?php echo e(route('website.login')); ?>" class="btn btn-inline post-btn"> <i class="far fa-user"></i>
                        <span> <?php echo e(__('website.login')); ?> </span></a>
                <?php else: ?>
                    <a href="<?php echo e(route('website.profile',auth()->id())); ?>" class="btn btn-inline post-btn"> <i
                                class="far fa-user"></i>
                        <span> <?php echo e(__('website.my-profile')); ?> </span></a>

                <?php endif; ?>
            </div>

        </div>
    </div>
</header>
<aside class="sidebar-part">
    <div class="sidebar-body">
        <div class="sidebar-header"><a href="<?php echo e(route('website.index')); ?>" class="sidebar-logo"><img
                        src="<?php echo e(asset('website/images/logo.png')); ?>"
                        alt="logo"></a>
            <button class="sidebar-cross"><i class="fas fa-times"></i></button>
        </div>
        <div class="sidebar-content">
            <?php if(auth()->user()): ?>
                <div class="sidebar-profile">
                    <a href="<?php echo e(route('website.profile',auth()->id())); ?>" class="sidebar-avatar"><img
                                src="<?php echo e(auth()->user()->image()?auth()->user()->image():asset('/website/images/avatar/profile-default.png')); ?>"
                                alt="avatar"></a>
                    <h4>
                        <a href="<?php echo e(route('website.profile',auth()->id())); ?>"
                           class="sidebar-name"><?php echo e(auth()->user()->name); ?></a></h4>
                </div>
            <?php else: ?>
                <div class="sidebar-profile">
                    <a class="sidebar-avatar"><img
                                src="<?php echo e(asset('/website/images/avatar/profile-default.png')); ?>"
                                alt="avatar"></a>
                    <h4>
                        <a class="sidebar-name"><?php echo e(__('website.username')); ?></a></h4>
                </div>

            <?php endif; ?>
            <div class="sidebar-menu">
                <ul class="nav nav-tabs">
                    <li><a href="#main-menu" class="nav-link active" data-toggle="tab"><?php echo e(__('website.main-menu')); ?></a>
                    </li>

                        <li><a href="#author-menu" class="nav-link" data-toggle="tab"><?php echo e(__('website.profile')); ?> </a>
                        </li>

                </ul>
                <div class="tab-pane active" id="main-menu">
                    <ul class="navbar-list">
                        <li class="navbar-item"><a class="navbar-link"
                                                   href="<?php echo e(route('website.index')); ?>"><?php echo e(__('website.home')); ?></a></li>
                        <li class="navbar-item"><a class="navbar-link"
                                                   href="<?php echo e(route('website.view-all-explores')); ?>"><?php echo e(__('website.explore')); ?></a>
                        </li>
                        <li class="navbar-item"><a class="navbar-link"
                                                   href="<?php echo e(route('website.about')); ?>"><?php echo e(__('website.about-moon')); ?></a>
                        </li>
                        <li class="navbar-item"><a class="navbar-link"
                                                   href="<?php echo e(route('website.shops-on-map')); ?>"> <?php echo e(__('website.moon-map')); ?></a>
                        </li>

                        <li class="navbar-item"><a class="navbar-link"
                                                   href="<?php echo e(route('website.all-shops','all')); ?>"><?php echo e(__('website.shops')); ?></a>
                        </li>
                        <li class="navbar-item navbar-dropdown"><a class="navbar-link"
                            ><span><?php echo e(__('website.categories')); ?></span><i
                                        class="fas fa-plus"></i></a>
                            <ul class="dropdown-list">

                                <?php $__currentLoopData = $categories; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $category): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <li><a class="dropdown-link"
                                           href="<?php echo e(route('website.all-advertisements',$category->slug)); ?>?type=View"><?php echo e($category->name); ?></a>
                                    </li>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>

                            </ul>
                        </li>
                        <li class="navbar-item"><a class="navbar-link"
                                                   href="<?php echo e(route('website.packages')); ?>"><?php echo e(__('website.moon-pricing')); ?></a>
                        </li>
                        <li class="navbar-item"><a class="navbar-link"
                                                   href="<?php echo e(route('website.view-all-blogs')); ?>"><?php echo e(__('website.blogs')); ?></a>
                        </li>

                        <li class="navbar-item"><a class="navbar-link"
                                                   href="<?php echo e(route('website.contact-us')); ?>"><?php echo e(__('website.contact-us')); ?></a>
                        </li>
                        <li class="navbar-item"><a class="navbar-link"
                                                   href="<?php echo e(route('website.terms')); ?>"><?php echo e(__('website.terms-and-conditions')); ?></a>
                        </li>
                        <li class="navbar-item"><a class="navbar-link"
                                                   href="<?php echo e(route('website.help','how-to-use')); ?>"><?php echo e(__('website.how-to-use')); ?> <?php echo e(__('website.moon')); ?></a>
                        </li>
                        <li class="navbar-item"><a class="navbar-link"
                                                   href="<?php echo e(route('website.help','help')); ?>"><?php echo e(__('website.help')); ?></a>
                        </li>
                        <li class="navbar-item"><a class="navbar-link"
                                                   href="<?php echo e(route('store.register')); ?>"><?php echo e(__('website.register-as-shop')); ?></a>
                        </li>
                        <?php if(app()->getLocale()=='ar'): ?>
                        <li class="navbar-item"><a class="navbar-link"
                                                   href="<?php echo e(route('website.change-language',['language'=>'en'])); ?>"><?php echo e(__('website.change-language')); ?></a>
                        </li>
                        <?php else: ?>
                            <li class="navbar-item"><a class="navbar-link"
                                                       href="<?php echo e(route('website.change-language',['language'=>'ar'])); ?>"><?php echo e(__('website.change-language')); ?></a>

                        <?php endif; ?>
                    </ul>
                </div>
                <?php if(auth()->user()): ?>
                    <div class="tab-pane" id="author-menu">
                        <ul class="navbar-list">
                            <li class="navbar-item"><a class="navbar-link"
                                                       href="<?php echo e(route('website.profile',auth()->id())); ?>"><?php echo e(__('website.edit-profile')); ?></a>
                            </li>
                            <li class="navbar-item"><a class="navbar-link"
                                                       href="<?php echo e(route('website.last-seen-ads')); ?>"><?php echo e(__('website.last-seen-ads')); ?></a>
                            </li>
                            <li class="navbar-item"><a class="navbar-link"
                                                       href="<?php echo e(route('website.followed-shops')); ?>"><?php echo e(__('website.followed-shops')); ?></a>
                            </li>
                            
                            
                            <li class="navbar-item"><a class="navbar-link"
                                                       href="<?php echo e(route('website.blocked-shops')); ?>"><?php echo e(__('website.blocked-shops')); ?></a>
                            </li>
                            <li class="navbar-item"><a class="navbar-link"
                                                       href="<?php echo e(route('website.last-search')); ?>"><?php echo e(__('website.last-search')); ?></a>
                            </li>
                            <li class="navbar-item navbar-dropdown"><a class="navbar-link"
                                                                       href="<?php echo e(route('website.favorites')); ?>"><span><?php echo e(__('website.favorites')); ?></span><span><?php echo e(auth()->user()?count($favorites):$favorites); ?></span></a>
                            </li>
                            <li class="navbar-item navbar-dropdown"><a class="navbar-link"
                                                                       href="<?php echo e(route('website.notifications')); ?>"><span><?php echo e(__('website.notifications')); ?></span><span><?php echo e(auth()->user()?auth()->user()->notification_count:0); ?></span></a>
                            </li>
                            <li class="navbar-item"><a class="navbar-link"
                                                       href="<?php echo e(route('website.logout')); ?>"><?php echo e(__('website.logout')); ?></a>
                            </li>
                        </ul>
                    </div>
                <?php else: ?>
                    <div class="tab-pane" id="author-menu">
                        <ul class="navbar-list">
                            <li class="navbar-item"><a class="navbar-link"
                                                       href="<?php echo e(route('website.login')); ?>"><?php echo e(__('website.edit-profile')); ?></a>
                            </li>
                            <li class="navbar-item"><a class="navbar-link"
                                                       href="<?php echo e(route('website.login')); ?>"><?php echo e(__('website.last-seen-ads')); ?></a>
                            </li>
                            <li class="navbar-item"><a class="navbar-link"
                                                       href="<?php echo e(route('website.login')); ?>"><?php echo e(__('website.followed-shops')); ?></a>
                            </li>
                            
                            
                            <li class="navbar-item"><a class="navbar-link"
                                                       href="<?php echo e(route('website.login')); ?>"><?php echo e(__('website.blocked-shops')); ?></a>
                            </li>
                            <li class="navbar-item"><a class="navbar-link"
                                                       href="<?php echo e(route('website.login')); ?>"><?php echo e(__('website.last-search')); ?></a>
                            </li>
                            <li class="navbar-item navbar-dropdown"><a class="navbar-link"
                                                                       href="<?php echo e(route('website.login')); ?>"><span><?php echo e(__('website.favorites')); ?></span><span><?php echo e(auth()->user()?count($favorites):$favorites); ?></span></a>
                            </li>
                            <li class="navbar-item navbar-dropdown"><a class="navbar-link"
                                                                       href="<?php echo e(route('website.login')); ?>"><span><?php echo e(__('website.notifications')); ?></span><span><?php echo e(auth()->user()?auth()->user()->notification_count:0); ?></span></a>
                            </li>
                            <li class="navbar-item"><a class="navbar-link"
                                                       href="<?php echo e(route('website.login')); ?>"><?php echo e(__('website.login')); ?></a>
                            </li>
                        </ul>
                    </div>

                <?php endif; ?>
            </div>
            <div class="sidebar-footer">
                <p><?php echo e(__('website.copy-right')); ?> <a href="<?php echo e(route('website.index')); ?>"><?php echo e(__('website.moon')); ?></a></p>

            </div>
        </div>
    </div>
</aside>
<nav class="mobile-nav">
    <div class="container">
        <div class="mobile-group">
            <a href="<?php echo e(route('website.index')); ?>" class="mobile-widget"><i
                        class="fas fa-home"></i><span><?php echo e(__('website.home')); ?></span></a>
            <?php if(auth()->user()): ?>
                <a href="<?php echo e(route('website.profile',auth()->id())); ?>"
                   class="mobile-widget"><i
                            class="fas fa-user"></i><span><?php echo e(__('website.profile')); ?></span></a>
                <a
                        href="<?php echo e(route('website.notifications')); ?>" class="mobile-widget"><i
                            class="fas fa-bell"></i><span><?php echo e(__('website.notifications')); ?></span><sup>0</sup></a>

            <?php else: ?>
                <a href="<?php echo e(route('website.login')); ?>" class="mobile-widget"><i
                            class="fas fa-user"></i><span><?php echo e(__('website.profile')); ?></span></a>
                <a
                        href="<?php echo e(route('website.login')); ?>" class="mobile-widget"><i
                            class="fas fa-bell"></i><span><?php echo e(__('website.notifications')); ?></span><sup>0</sup></a>

            <?php endif; ?>
        </div>
    </div>
</nav>
<?php /**PATH /home/mtest/public_html/_wildcard_/resources/views/Website/layouts/includes/header.blade.php ENDPATH**/ ?>