<!DOCTYPE html>
<html lang="<?php echo e(app()->getLocale()); ?>" <?php if(app()->getLocale()=='ar'): ?> dir="rtl" <?php endif; ?> >
<meta http-equiv="content-type" content="text/html;charset=utf-8"/>

<head>
    <meta charset="UTF-8">
    <meta http-equiv="X-UA-Compatible" content="IE=edge">
    <title><?php echo $__env->yieldContent('page-title'); ?></title>

    <meta name="viewport" content="width=device-width, initial-scale=1, shrink-to-fit=no">
    <?php echo $__env->yieldContent('meta-deep-link'); ?>
    <meta name="title" content="<?php echo e(isset($title)?$title:$settings[\App\Helpers\Constant::SETTING_KEYS['Meta']]->title); ?>">
    <meta name="description" content="<?php echo e(isset($description)?$description:$settings[\App\Helpers\Constant::SETTING_KEYS['Meta']]->content); ?>">
    

    <link rel="canonical" href="<?php echo e(Request::fullUrl()); ?>">
    <link rel="apple-touch-icon" href="<?php echo e(asset('website/images/favicon.png')); ?>">
    <?php echo $__env->yieldContent('profile-css'); ?>
    <link rel="preload" href="https://cdnjs.cloudflare.com/ajax/libs/normalize/5.0.0/normalize.min.css" as="style" onload="this.rel='stylesheet'"  media="screen">
    <link rel='preload' href='https://cdnjs.cloudflare.com/ajax/libs/lightbox2/2.8.2/css/lightbox.min.css' as="style" onload="this.rel='stylesheet'" media="screen">
    <link rel="preload" href="<?php echo e(asset('website/css/custom/style-gallery.css')); ?>" as="style" onload="this.rel='stylesheet'" media="screen">
    <link rel="preload" href="<?php echo e(asset('website/fonts/flaticon/flaticon.css')); ?>" as="style" media="screen">
    <link rel="preload"  as="style"  href="<?php echo e(asset('website/fonts/font-awesome/fontawesome.css')); ?>" onload="this.rel='stylesheet'" media="screen">
    <link rel="preload" as="style"
          href="<?php echo e(app()->getLocale()=='en'?asset('website/css/vendor/slick.min.css'):asset('website/css/vendor/slick.min-rtl.css')); ?>"
          media="screen" onload="this.rel='stylesheet'">
    <link rel="preload" as="style"
          href="<?php echo e(asset('website/css/vendor/nice-select.min.css')); ?>"
          media="screen" onload="this.rel='stylesheet'">
    <link rel="preload" as="style"
          href="<?php echo e(app()->getLocale()=='en'?asset('website/css/vendor/bootstrap.min.css'):asset('website/css/vendor/bootstrap.min-rtl.css')); ?>"
          media="screen" onload="this.rel='stylesheet'">
    <link rel="stylesheet"
          href="<?php echo e(app()->getLocale()=='en'?asset('website/css/custom/main.css'):asset('website/css/custom/main-rtl.css')); ?>"
          media="screen" >
    <link rel="preload" as="style" href="<?php echo e(asset('website/css/custom/index.css')); ?>" onload="this.rel='stylesheet'" media="screen">
    <link rel="preload" as="style" href="<?php echo e(asset('website/css/custom/style-story.css')); ?>" onload="this.rel='stylesheet'"  media="screen">
    <link rel="preload" as="style" href="<?php echo e(asset('website/css/custom/zuck.min.css')); ?>" onload="this.rel='stylesheet'"  media="screen">
    <link rel="preload" as="style" href="<?php echo e(asset('website/css/custom/snapgram.css')); ?>" onload="this.rel='stylesheet'" media="screen">
    <script src="https://cdnjs.cloudflare.com/ajax/libs/axios/0.27.2/axios.min.js"
            integrity="sha512-odNmoc1XJy5x1TMVMdC7EMs3IVdItLPlCeL5vSUPN2llYKMJ2eByTTAIiiuqLg+GdNr9hF6z81p27DArRFKT7A=="
            crossorigin="anonymous" referrerpolicy="no-referrer" async></script>
    <link rel="preload" href="<?php echo e(asset('website/css/custom/404.css')); ?>" as="style" media="screen" onload="this.rel='stylesheet'">
    <link rel="preload" href="<?php echo e(asset('website/css/custom/toast.css')); ?>" as="style" media="screen" >
    <link rel="shortcut icon" href="<?php echo e(asset('website/images/favicon.png')); ?>" type="image/x-icon">
    <link rel="icon" href="<?php echo e(asset('website/images/favicon.png')); ?>">

    <?php echo $__env->yieldContent('extra-css'); ?>
</head>
<body>
<?php echo $__env->make('Website.layouts.includes.header', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
<?php echo $__env->yieldContent('banner'); ?>
<?php echo $__env->yieldContent('content'); ?>
<?php echo $__env->make('Website.layouts.includes.footer', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
<script>
    function foo() {
        alert("Submit button clicked!");
        return true;
    }
</script>

<script rel="preload"  src="<?php echo e(asset('website/js/vendor/jquery-1.12.4.min.js')); ?>"></script>
<script rel="preload" src="<?php echo e(asset('website/js/vendor/popper.min.js')); ?>"></script>
<script  rel="preload" src="<?php echo e(asset('website/js/vendor/bootstrap.min.js')); ?>"></script>
<script rel="preload" src="<?php echo e(asset('website/js/vendor/slick.min.js')); ?>"></script>
<script rel="preload" src="<?php echo e(asset('website/js/custom/slick.js')); ?>"></script>
<script src="<?php echo e(asset('website/js/custom/main.js')); ?>" defer></script>
<link rel="preload" as="style" type="text/css" href="//cdnjs.cloudflare.com/ajax/libs/toastr.js/latest/css/toastr.css">
<script src="//cdnjs.cloudflare.com/ajax/libs/toastr.js/latest/js/toastr.min.js"></script>

<?php echo $__env->yieldContent('extra-js-files'); ?>
<?php if(auth()->user()): ?>
    <script defer src="https://widget-js.cometchat.io/v3/cometchatwidget.js"></script>
    <script>

        
        
        
        
        
        
        

        
        

        

        
        
        
        
        
        
        
        
        
        
        

        
        
        
        
        
        
        
        
        
        
        
        
    </script>
<?php endif; ?>
<script>
    function changeCountry(country_id, country_name) {
        axios.get("<?php echo e(route('website.change-country')); ?>", {
            params: {
                country: country_id,
                country_name: country_name,

            }
        })
            .then(function (response) {
                location.reload();

            })

    }

    function selectSubCategory(category_id) {
        axios.get("<?php echo e(route('website.get-sub-categories')); ?>", {
            params: {
                category_id: category_id,

            }
        })
            .then(function (response) {
                var result = response.data;
                console.log(response.data);
                $('#select-sub-category').empty();
                $('#select-sub-category')
                    .append('<option label="<?php echo e(__("website.select-sub-category")); ?>"></option>');

                $.each(result, function (key, value) {
                    $('#select-sub-category')
                        .append($("<option></option>")
                            .attr("value", key)
                            .text(value));
                });

                $('#select-sub-category').attr('disabled', false);
            })

    }
</script>
<script>
    toastr.options = {
        "debug": false,
        "positionClass": "toast-bottom-right",
        "onclick": null,
        "fadeIn": 300,
        "fadeOut": 1000,
        "timeOut": 5000,
        "extendedTimeOut": 1000
    }

        <?php if(Session::has('message')): ?>
    var type = "<?php echo e(Session::get('type', 'info')); ?>";
    switch (type) {
        case 'info':
            toastr.info("<?php echo e(Session::get('message')); ?>");
            break;
        case 'warning':
            toastr.warning("<?php echo e(Session::get('message')); ?>");
            break;
        case 'success':
            toastr.success("<?php echo e(Session::get('message')); ?>");
            break;
        case 'error':
            toastr.error("<?php echo e(Session::get('message')); ?>");
            break;
    }

        <?php endif; ?>
        <?php if($errors->any() ?: 0): ?>{
        toastr.error(<?php echo e(__('Whoops! Something went wrong.')); ?>);


    <?php endif; ?>

</script>
<script>
    function follow(shop_id) {
        let Button = $('#follow-' + shop_id);
        let Span = $('#follow-' + shop_id + ' span');
        let UserIcon = $('#follow-' + shop_id + ' i');
        let Icon = $('#follow-icon');
        let Section = $('#follow-section-' + shop_id);
        let Count = $('#followers-count');
        axios.get("<?php echo e(route('website.follow')); ?>", {
            params: {
                shop_id: shop_id,

            }
        })
            .then(function (response) {
                console.log(response.data);
                var type = response.data.type;
                switch (type) {
                    case 'warning':
                        toastr.warning(response.data.message);
                        break;
                    case 'success':
                        toastr.success(response.data.message);
                        break;
                    case 'error':
                        toastr.error(response.data.message);
                        break;
                }
                if (response.data.followType == 'follow') {
                    Span.text('<?php echo e(__('website.un-follow')); ?>');
                    Button.removeClass('btn-secondary');
                    Icon.addClass('active');
                    UserIcon.removeClass('fa-user');
                    UserIcon.addClass('fa-user-times');
                    Count.text(parseInt(Count.text()) + 1);

                } else {
                    Span.text('<?php echo e(__('website.follow')); ?>');
                    Button.addClass('btn-secondary');
                    Icon.removeClass('active');
                    UserIcon.removeClass('fa-user-times');
                    UserIcon.addClass('fa-user');

                    Section.hide('slow', function () {
                        Section.remove();
                    });

                    Count.text(parseInt(Count.text()) - 1);
                    if (Count.text() == 0) {
                        let error = '<section class="error-part">\n' +
                            '    <div class="container">\n' +
                            ' <div class="error">\n' +
                            '\n' +
                            '                <h2>Sorry</h2>\n' +
                            '                <img src="<?php echo e(asset('website/images/empty.gif')); ?>" alt="error" class="mx-30">\n' +
                            '                <h2><?php echo e(__('website.empty-text')); ?> </h2>\n' +
                            '                <a href="<?php echo e(route('website.index')); ?>" class="btn btn-outline"><i\n' +
                            '                        class="fas fa-home"></i><span><?php echo e(__('website.go-to-homepage')); ?></span></a>\n' +
                            '            </div>\n' +
                            '        </div>\n' +
                            ' </section>\n';
                        $('#shops').hide('slow', function () {
                            $('.inner-section.ad-list-part').remove();
                        });

                        $('#content-section').append(error);

                    }


                }

            })

    }

</script>
<script>
    function favorite(advertisement_id) {
        let Button = $('#favorite' + advertisement_id);
        let Count = $('#favorite-count');
        let CountAd = $('#ad-favorite-count');
        let Section = $('#favorite-section-' + advertisement_id);

        axios.get("<?php echo e(route('website.favorite')); ?>", {
            params: {
                advertisement_id: advertisement_id,

            }
        })
            .then(function (response) {
                var type = response.data.type;
                switch (type) {
                    case 'warning':
                        toastr.warning(response.data.message);
                        break;
                    case 'success':
                        toastr.success(response.data.message);
                        break;
                    case 'error':
                        toastr.error(response.data.message);
                        break;
                }
                if (response.data.favoriteType == 'favorite') {
                    Button.addClass('active');
                    Count.text(parseInt(Count.text()) + 1);

                    CountAd.text(parseInt(CountAd.text()) + 1 );
                } else {
                    Button.removeClass('acitve');
                    Count.text(parseInt(Count.text()) - 1);
                    CountAd.text(parseInt(CountAd.text()) - 1);
                    Section.hide('slow', function () {
                        Section.remove();
                    });


                    if (Count.text() == 0) {
                        let error = '<section class="error-part">\n' +
                            '    <div class="container">\n' +
                            ' <div class="error">\n' +
                            '\n' +
                            '                <h2>Sorry</h2>\n' +
                            '                <img src="<?php echo e(asset('website/images/empty.gif')); ?>" alt="error" class="mx-30">\n' +
                            '                <h2><?php echo e(__('website.empty-text')); ?> </h2>\n' +
                            '                <a href="<?php echo e(route('website.index')); ?>" class="btn btn-outline"><i\n' +
                            '                        class="fas fa-home"></i><span><?php echo e(__('website.go-to-homepage')); ?></span></a>\n' +
                            '            </div>\n' +
                            '        </div>\n' +
                            ' </section>\n';
                        $('#favorites').hide('slow', function () {
                            $('#favorites').remove();
                        });

                        $('#content-section').append(error);

                    }


                }

            })

    }
</script>

</body>
</html>
<?php /**PATH /home/mtest/public_html/_wildcard_/resources/views/Website/layouts/app.blade.php ENDPATH**/ ?>