<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('advertisements', function (Blueprint $table) {
            $table->id();
            $table->foreignId('store_id')->nullable()->references('id')
                ->on('users')->nullOnDelete();
            $table->foreignId('city_id')->nullable()->references('id')
                ->on('countries')->nullOnDelete();
            $table->foreignId('sub_category_id')->nullable()->references('id')
                ->on('categories')->nullOnDelete();
            $table->string('title');
            $table->string('slug');
            $table->string('phone')->nullable();
            $table->float('price', 13, 2)->default(0);
            $table->boolean('premium')->default(\App\Helpers\Constant::PREMIUM_STATUS['False']);
            $table->boolean('is_negotiable')->default(\App\Helpers\Constant::NEGOTIABLE_STATUS['False']);
            $table->integer('views_count')->default(0);
            $table->integer('search_count')->default(0);
            $table->integer('favorite_count')->default(0);
            $table->integer('share_count')->default(0);
            $table->float('latitude')->default(0);
            $table->float('longitude')->default(0);
            $table->float('average_rate', 8 , 1)->default(0);
            $table->integer('rate_count')->default(0);
            $table->text('description')->nullable();
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('advertisements');
    }
};
