<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateBlogsTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('blogs', function (Blueprint $table) {
            $table->id();
            $table->integer('share_count')->default(0);
            $table->foreignId('author_id')->nullable()->references('id')
                ->on('admins')->nullOnDelete();

            $table->timestamps();
        });
        Schema::create('blog_translations', function(Blueprint $table) {
            $table->id();
            $table->foreignId('blog_id')->nullable()->constrained()->nullOnDelete();
            $table->string('locale', 2)->index();
            $table->string('title');
            $table->string('slug');
            $table->text('description');
            $table->text('quote');
            $table->unique(['blog_id','locale']);
        });

    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('blogs');
    }
}
